//+------------------------------------------------------------------+
//|                                             fawaz ALERT TEST.mq4 |
//|                                                      Nicholishen |
//|                                                 nick@barker.net  |
//+------------------------------------------------------------------+
#property copyright "Nicholishen"
#property link      "www.tradingintl.com"
#include <WinUser32.mqh> 
//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
extern bool UseCrossMode=false;
extern bool UseOBOSMode=true;
extern string init="0 periods will alert immediately";
extern int PeriodsToConfirmX=1;
extern string ggg="Stochastic Settings";
extern int K=5,D=3,SL=3;
extern int OB_OS_mode=1;

int obos(int t,int pd){
   double
   ylw=iStochastic(NULL,0,K,D,SL,MODE_SMA,0,MODE_MAIN,pd),
   ppl=iStochastic(NULL,0,K,D,SL,MODE_SMA,0,MODE_SIGNAL,pd);
   
   if (t==1){
      if(ylw>80)return(2);
      if(ylw<20)return(1);
   }
   if (t==2){
      if(ylw>80 && ppl > 80)return(2);
      if(ylw<20 && ppl < 20)return(1);
   }
return(0);
}


int cross(int pd){
   double 
   ylw=iStochastic(NULL,0,K,D,SL,MODE_SMA,0,MODE_MAIN,pd),
   ppl=iStochastic(NULL,0,K,D,SL,MODE_SMA,0,MODE_SIGNAL,pd),
   ylwpre=iStochastic(NULL,0,K,D,SL,MODE_SMA,0,MODE_MAIN,pd+1),
   pplpre=iStochastic(NULL,0,K,D,SL,MODE_SMA,0,MODE_SIGNAL,pd+1);
   
   if(ylw>ppl && ylwpre<pplpre)return(1);
   if(ylw<ppl && ylwpre>pplpre)return(2);
   
   return(0);
}
string fin(int trend){
   if(trend==1)return("UP");
   if(trend==2)return("DOWN");
}
   
int init(){
   int j=PeriodsToConfirmX;
   for(int i=1000;i>0;i--){
      if(cross(i)==1){int trend=1; int per=i;}
      if(cross(i)==2){ trend=2; per=i;}
      if(obos(1,i)==1){int ind =1;int per2=i;}
      if(obos(1,i)==2){ ind =2;per2=i;}
   }
   if(ind == 1)string o=" < 20 ";
   if(ind == 2) o=" > 80 ";
   if(trend==1)string k="UP";
   if(trend==2) k="DOWN";
   
   Comment("\n","Indicators last crossed ",k," ",per," periods ago.","\n",
   " Stochastics were last",o," ",per2," periods ago.");
   PlaySound("alert.wav");
   Alert("Indicators Have Crossed ",fin(trend)," ",per," periods ago.");


   return(0);
  }
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start(){

int i= PeriodsToConfirmX;
   static int bar,bar2,cancel,cancel2;
 if(UseCrossMode){
   if(bar!=Bars)cancel=0;
   if(cancel == 7 || cancel==0){ 
      if(cross(i)==1){
         PlaySound("alert.wav");Alert("Indicators Have Crossed ",fin(1));
         Comment("UP");
         int ret=MessageBox("Cancel Alerts for This Period?",NULL,MB_YESNO|MB_ICONQUESTION);
         if(ret==IDYES){
            cancel=6;bar=Bars;
         }
      }     
      if(cross(i)==2){
         PlaySound("alert.wav");Alert("Indicators Have Crossed ",fin(2));
         Comment("DOWN");
         ret=MessageBox("Cancel Alerts for This Period?",NULL,MB_YESNO|MB_ICONQUESTION);
         if(ret==IDYES){
            cancel=6;bar=Bars;
         }
      }
   }
}
int m=OB_OS_mode;

if(UseOBOSMode){
   if(bar2!=Bars)cancel2=0;
   if(cancel2 == 7 || cancel2==0){ 
      if(obos(m,i)==1){
         PlaySound("alert.wav");Alert("Stochastics < 20 ");
         Comment("<20");
         int ret2=MessageBox("Cancel Alerts for This Period?",NULL,MB_YESNO|MB_ICONQUESTION);
         if(ret2==IDYES){
            cancel2=6;bar2=Bars;
         }
      }     
      if(obos(m,i)==2){
         PlaySound("alert.wav");Alert("Stochastics > 80 ");
         Comment(">80");
         ret2=MessageBox("Cancel Alerts for This Period?",NULL,MB_YESNO|MB_ICONQUESTION);
         if(ret2==IDYES){
            cancel2=6;bar2=Bars;
         }
      }
   }
}
   
   return(0);
  }
//+------------------------------------------------------------------+